// (c) 1999 - 2025 OneSpan North America Inc. All rights reserved.


/////////////////////////////////////////////////////////////////////////////
//
//
// This file is example source code. It is provided for your information and
// assistance. See your licence agreement for details and the terms and
// conditions of the licence which governs the use of the source code. By using
// such source code you will be accepting these terms and conditions. If you do
// not wish to accept these terms and conditions, DO NOT OPEN THE FILE OR USE
// THE SOURCE CODE.
//
// Note that there is NO WARRANTY.
//
//////////////////////////////////////////////////////////////////////////////


import MSSOrchestration

enum OrchestratorUtils {
    static func getOrchestrator(delegate: OrchestrationSampleDelegate, collectCDDC: Bool = true) -> Orchestrator? {
        let cddcParams = CDDCParameters()
        var orchestrator: Orchestrator?
        
        var appAccessGroup: OrchestrationAccessGroup {
            OrchestrationAppPrivate(teamId: ConfigurableConstants.teamId, bundleId: ConfigurableConstants.bundleId)
        }
        
        do {
            // Set up CDDC parameters
            try cddcParams.add(optionalRetrievableField: .bluetooth)
            try cddcParams.add(optionalRetrievableField: .geolocation)
            let parameters = OrchestrationParameters(digipassSalt: ConfigurableConstants.Salt.digipass,
                                                     storageSalt: ConfigurableConstants.Salt.storage,
                                                     defaultDomain: ConfigurableConstants.domainId, accessGroup: appAccessGroup,
                                                     errorDelegate: delegate,
                                                     warningDelegate: delegate,
                                                     cddcParams: cddcParams)
            orchestrator = try OrchestratorBuilder.build(with: parameters)
            
            // Set values for the CDDC when available
            if let feeder = orchestrator?.cddcDataFeeder, collectCDDC {
                CDDCUtils.configure(cddcDataFeeder: feeder)
            }
        } catch {
            guard let orchestrationError = error as? OrchestrationError else {
                assertionFailure("Unexpected error type")
                return nil
            }
            
            print("Error when getting the orchestrator: \(orchestrationError)")
        }
        
        return orchestrator
    }
}
